/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityTextChange;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.LanguageSystem;

public class GUITextEditor
extends AGUIBase {
    private static final int signScale = 32;
    private final boolean forSigns;
    private GUIComponent3DModel modelRender;
    private GUIComponentButton confirmButton;
    private int boxWidth;
    private int populatingPageHeight;
    private final List<Map<String, TextBoxStruct>> textInputBoxes = new ArrayList<Map<String, TextBoxStruct>>();
    private GUIComponentButton prevPageButton;
    private GUIComponentButton nextPageButton;
    private int currentPage;
    private final AEntityD_Definable<?> entity;
    private final Map<GUIComponentLabel, GUIComponentTextBox> signTextLabels = new HashMap<GUIComponentLabel, GUIComponentTextBox>();

    public GUITextEditor(AEntityD_Definable<?> entity) {
        this.entity = entity;
        this.forSigns = entity instanceof TileEntityPole_Sign;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        if (this.forSigns) {
            this.modelRender = new GUIComponent3DModel(this.guiLeft + 3 * this.getWidth() / 4, this.guiTop + 110, 32.0f, false, false, true);
            this.addComponent(this.modelRender);
            this.modelRender.modelLocation = ((AJSONMultiModelProvider)this.entity.definition).getModelLocation(this.entity.subDefinition);
            this.modelRender.textureLocation = ((AJSONMultiModelProvider)this.entity.definition).getTextureLocation(this.entity.subDefinition);
            this.boxWidth = 100;
        } else {
            this.boxWidth = 200;
        }
        this.textInputBoxes.clear();
        this.signTextLabels.clear();
        this.addTextFromEntity(this.entity);
        if (this.entity instanceof AEntityF_Multipart) {
            ((AEntityF_Multipart)this.entity).allParts.forEach(part -> this.addTextFromEntity((AEntityD_Definable<?>)part));
        }
        this.prevPageButton = new GUIComponentButton(this, this.guiLeft + 20, this.guiTop + 10, 20, 20, "<"){

            @Override
            public void onClicked(boolean leftSide) {
                --GUITextEditor.this.currentPage;
            }
        };
        this.addComponent(this.prevPageButton);
        this.nextPageButton = new GUIComponentButton(this, this.guiLeft + 100, this.guiTop + 10, 20, 20, ">"){

            @Override
            public void onClicked(boolean leftSide) {
                ++GUITextEditor.this.currentPage;
            }
        };
        this.addComponent(this.nextPageButton);
        this.confirmButton = new GUIComponentButton(this, this.guiLeft + 150, this.guiTop + 15, 80, 20, LanguageSystem.GUI_CONFIRM.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUITextEditor.this.textInputBoxes.forEach(page -> page.forEach((textKey, textStruct) -> ((TextBoxStruct)textStruct).entities.forEach(textEntity -> InterfaceManager.packetInterface.sendToServer(new PacketEntityTextChange((AEntityD_Definable<?>)textEntity, (String)textKey, ((TextBoxStruct)textStruct).textBox.text)))));
                GUITextEditor.this.close();
            }
        };
        this.addComponent(this.confirmButton);
    }

    private void addTextFromEntity(AEntityD_Definable<?> entity) {
        for (Map.Entry<JSONText, String> textEntry : entity.text.entrySet()) {
            this.addSingleTextEntry(entity, textEntry);
        }
    }

    private void addSingleTextEntry(AEntityD_Definable<?> entity, Map.Entry<JSONText, String> textEntry) {
        JSONText textDef = textEntry.getKey();
        String textKey = textDef.fieldName;
        if (textKey != null) {
            for (Map<String, TextBoxStruct> page : this.textInputBoxes) {
                if (!page.containsKey(textKey)) continue;
                page.get(textKey).entities.add(entity);
                return;
            }
            int textRowsRequired = 1 + 5 * textDef.maxLength / this.boxWidth;
            int textBoxHeight = 12 * textRowsRequired;
            int boxSpacing = 12;
            int boxOffsetFromLabel = 10;
            int maxLowerLimit = this.getHeight() - boxSpacing;
            if (this.textInputBoxes.isEmpty() || this.populatingPageHeight + boxSpacing + boxOffsetFromLabel + textBoxHeight > maxLowerLimit) {
                this.textInputBoxes.add(new HashMap());
                this.populatingPageHeight = 0;
            }
            GUIComponentLabel textLabel = new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 30 + this.populatingPageHeight, ColorRGB.BLACK, textKey);
            this.addComponent(textLabel);
            GUIComponentTextBox textBox = new GUIComponentTextBox(this, this.guiLeft + 20, textLabel.constructedY + boxOffsetFromLabel, this.boxWidth, textBoxHeight, entity.text.get(textDef), ColorRGB.WHITE, textDef.maxLength);
            this.addComponent(textBox);
            textLabel.setComponent(textBox);
            if (this.forSigns) {
                GUIComponentLabel signLabel = new GUIComponentLabel(this.modelRender.constructedX + (int)(textDef.pos.x * 32.0), this.modelRender.constructedY - (int)(textDef.pos.y * 32.0), textDef.color, textBox.text, RenderText.TextAlignment.values()[textDef.renderPosition], textDef.scale * 32.0f / 16.0f, textDef.wrapWidth * 32 / 16, textDef.fontName, textDef.autoScale);
                this.addComponent(signLabel);
                this.signTextLabels.put(signLabel, textBox);
            }
            this.textInputBoxes.get(this.textInputBoxes.size() - 1).put(textKey, new TextBoxStruct(textBox, entity));
            this.populatingPageHeight += boxOffsetFromLabel + textBox.height + boxSpacing;
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        this.prevPageButton.enabled = this.currentPage > 0;
        this.nextPageButton.enabled = this.currentPage + 1 < this.textInputBoxes.size();
        this.confirmButton.enabled = true;
        for (int i = 0; i < this.textInputBoxes.size(); ++i) {
            for (TextBoxStruct textBoxStruct : this.textInputBoxes.get(i).values()) {
                ((TextBoxStruct)textBoxStruct).textBox.visible = i == this.currentPage;
            }
        }
        this.signTextLabels.forEach((label, textBox) -> {
            label.text = textBox.getText();
        });
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.entity.isValid;
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    private class TextBoxStruct {
        private final GUIComponentTextBox textBox;
        private final List<AEntityD_Definable<?>> entities = new ArrayList();

        private TextBoxStruct(GUIComponentTextBox textBox, AEntityD_Definable<?> entity) {
            this.textBox = textBox;
            this.entities.add(entity);
        }
    }
}

